/**  Conversions to and from Fahrenheit, Centigrade, Kelvin */
public class TempConvert {
  /** = Fahrenheit equivalent of Centigrade temperature c */
  public static double FahrFromCent(double c)
     {return 9*c/5 + 32;}
     
  /** = Centigrade equivalent of Kelvin temperature k */
  public static double CentFromKelv(double k)
     {return k-273.16D;}
     
  /** = Kelvin equivalent of Fahrenheit temperature f */
  public static double KelvFromFahr(double f)
     {return (5*(f-32.0))/9 + 273.16D;}

  /** = Fahrenheit equivalent of Kelvin temperature k */
  public static double FahrFromKelv(double k)
     {return FahrFromCent(CentFromKelv(k));}

  /** = Centigrade equivalent of Fahrenheit temperature f */
  public static double CentFromFahr(double f)
     {return CentFromKelv(KelvFromFahr(f));}
     
  /** = Kelvin equivalent of Centigrade temperature c */
  public static double KelvFromCent(double c)
     {return KelvFromFahr(FahrFromCent(c));}
     
}
